/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.xml.XMLPlugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagUtil {
    public static boolean tagClosed(IDocument document, String openTag) {
        char c;
        String tagName = TagUtil.getTagName(openTag);
        int stack = 0;
        String src = document.get();
        int x = 0;
        int toAdd = tagName.length() + 1;
        String openTagPrefix = "<" + tagName;
        String closeTagPrefix = "</" + tagName;
        while ((x = src.indexOf(openTagPrefix, x)) != -1) {
            c = '>';
            if ((x += toAdd) < src.length()) {
                c = src.charAt(x);
            }
            if (c != '>' && !Character.isWhitespace(c)) continue;
            ++stack;
        }
        x = 0;
        toAdd = tagName.length() + 2;
        while ((x = src.indexOf(closeTagPrefix, x)) != -1) {
            c = '>';
            if ((x += toAdd) < src.length()) {
                c = src.charAt(x);
            }
            if (c != '>' && !Character.isWhitespace(c)) continue;
            --stack;
        }
        return stack <= 0;
    }

    public static IRegion findMatchingTag(IDocument document, int offset, Collection<String> partitionsToSearch) {
        ITypedRegion region;
        block6: {
            block5: {
                try {
                    region = document.getPartition(offset);
                    if (partitionsToSearch.contains(region.getType())) break block5;
                    return null;
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)XMLPlugin.getDefault(), (Throwable)e);
                    return null;
                }
            }
            String src = document.get(region.getOffset(), region.getLength());
            if (src.startsWith("</")) {
                return TagUtil.findMatchingOpen(document, region, partitionsToSearch);
            }
            if (!src.endsWith("/>")) break block6;
            return null;
        }
        return TagUtil.findMatchingClose(document, region, partitionsToSearch);
    }

    private static IRegion findMatchingClose(IDocument document, ITypedRegion region, Collection<String> partitionsToSearch) throws BadLocationException {
        return TagUtil.findMatch(document, region, true, partitionsToSearch);
    }

    private static IRegion findMatchingOpen(IDocument document, ITypedRegion region, Collection<String> partitionsToSearch) throws BadLocationException {
        return TagUtil.findMatch(document, region, false, partitionsToSearch);
    }

    private static IRegion findMatch(IDocument document, ITypedRegion region, boolean findClose, Collection<String> partitionsToSearch) throws BadLocationException {
        int length;
        int start;
        String tagSrc = document.get(region.getOffset(), region.getLength());
        if (tagSrc == null) {
            return null;
        }
        String tagName = TagUtil.getTagName(tagSrc);
        if (findClose) {
            start = region.getOffset() + region.getLength();
            length = document.getLength() - start;
        } else {
            start = 0;
            length = region.getOffset() - 1;
        }
        if (length < 0) {
            return null;
        }
        List<ITypedRegion> previousPartitions = Arrays.asList(document.computePartitioning(start, length));
        if (!findClose) {
            Collections.reverse(previousPartitions);
        }
        String closeTag = "</" + tagName + ">";
        String closeTagWithSpace = "</" + tagName + " ";
        String openTag = "<" + tagName + ">";
        String openTagWithSpace = "<" + tagName + " ";
        int stack = 1;
        for (ITypedRegion pp : previousPartitions) {
            if (!partitionsToSearch.contains(pp.getType())) continue;
            String src = document.get(pp.getOffset(), pp.getLength());
            if (src.startsWith(closeTagWithSpace) || src.startsWith(closeTag)) {
                stack = findClose ? --stack : ++stack;
            } else if (src.startsWith(openTagWithSpace) || src.startsWith(openTag)) {
                stack = findClose ? ++stack : --stack;
            }
            if (stack != 0) continue;
            return pp;
        }
        return null;
    }

    public static String getTagName(String openTag) {
        int spaceIndex;
        int index;
        String result = openTag;
        if (result.length() > 0 && result.charAt(0) == '<') {
            result = result.substring(1);
        }
        if (result.length() > 0 && result.charAt(0) == '/') {
            result = result.substring(1);
        }
        if ((index = result.indexOf(62)) != -1) {
            result = result.substring(0, index);
        }
        if ((spaceIndex = (result = result.trim()).indexOf(32)) != -1) {
            result = result.substring(0, spaceIndex);
        }
        return result;
    }

    public static boolean isStartTag(String source) {
        return source.length() > 0 && source.charAt(0) == '<' && !TagUtil.isEndTag(source);
    }

    public static boolean isEndTag(String source) {
        return source.startsWith("</");
    }
}

